import sql from 'mssql';
import { config } from './config.js';

const insertAuthors = async (authors) => {
  try {
    // Connect to the database
    await sql.connect(config);

    // Construct the insert query
    let query = 'INSERT INTO Authors (FirstName, LastName, BirthDate) VALUES ';

    // Build the values part of the query
    const values = authors
      .map(
        ({ firstName, lastName, birthDate }) =>
          `('${firstName}', '${lastName}', '${birthDate}')`
      )
      .join(', ');

    // Complete the query
    query += values;

    // Execute the query
    await sql.query(query);

    console.log(`${authors.length} authors were inserted successfully!`);
  } catch (err) {
    console.error('Error inserting authors:', err);
  } finally {
    // Close the database connection
    await sql.close();
  }
};

const authors = [
  { firstName: 'George', lastName: 'Orwell', birthDate: '1903-06-25' },
  { firstName: 'Jane', lastName: 'Austen', birthDate: '1775-12-16' },
  { firstName: 'Leo', lastName: 'Tolstoy', birthDate: '1828-09-09' },
];

// Call the function to insert the authors
insertAuthors(authors);
